/*******************************************************************
*
*  DESCRIPTION: Atomic Model RadarController
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 06/08/2009
*******************************************************************/

#ifndef __RADARCONTROLLER_H
#define __RADARCONTROLLER_H

/** include files **/
#include "atomic.h"     // class Atomic

/** declarations **/
class SensorController : public Atomic
{
public:
	SensorController( const std::string &name = "SensorController" ); //Default constructor
	virtual std::string className() const {  return "SensorController" ;}
	~SensorController();

protected:

	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &sctrl_mctrl_in, &sctrl_start_in, &sctrl_light_in;
	Port &sctrl_mctrl_out, &sctrl_start_out;
	
	Time scTxTime, scRxPrepTime;	//Data Prep Rx and Tx time_advance
	
	int sensor_input;
	
	enum State{
		IDLE,	//wait input from Movement controller
		PREP_RX,		//radar Controller prepare to work
		WAIT_DATA,       // radar waiting
		TX_DATA,			//ask MC to stop
		PREP_STOP
	} state;
};	// class RadarController

#endif   //__RADARCONTROLLER_H
